//Program Title: Image Enhancement - Image Contrast Stretching
//For Gray Image
//Sample Input:-
//Set value r1 (0<r1<255):75
//Set value r2 (r1<r2<255:175
//Set value s1 (0<s1<255):10
//Set value s2 (s1<s2<255:245
//Software version
//For: OS Windows7 and 8
//Scilab5.4.1 and above
//Image Processing Design Toolbox 8.3.1 and above
//Scilab Image and Video Proccessing toolbox 0.5.3.1-2 and above
//For: OS Ubuntu Linux 14.04 and above
//Scilab5.5.1 
//Image Processing Design Toolbox 8.3.1 and above
//Scilab Image and Video Proccessing toolbox 0.5.3.1-2 and above
//To read and write in the correct folder
//change the current directory in scilab console

clc;
clear all;

f=ReadImage('Exp6pout.jpg');// Get image as 16 bit unsigned integer 
OrigSize=size(f);//Get size of original image
OrigRow=OrigSize(1);//Get number of rows in original image
OrigCol=OrigSize(2);//Get number of colomns in original image

figure
ShowImage(f,'Original Image Pout')
WriteImage(f,'OriginalImagePout.jpg') //Comment out if you do not want o/p file to be written on disk

OrigHist=CreateHistogram(uint8(f));//Create Histogram
figure
plot2d3(OrigHist)//Show Histogram
title('Original Image Histogram')

//Image Contrast Stretching

disp('Image Contrast Stretching')
r1=input('Set value r1 (0<r1<255):');
r2=input('Set value r2 (r1<r2<255:');
s1=input('Set value s1 (0<s1<255):');
s2=input('Set value s2 (s1<s2<255:');

Alpha=s1/r1;
Beta=(s2-s1)/(r2-r1);
Gamma=(255-s2)/(255-r2);

ContStr=[];//Empty matrix for output image

for x=1:OrigRow
    for y=1:OrigCol
        if f(x,y)<r1 then;
            ContStr(x,y)=Alpha*f(x,y);
        elseif (f(x,y)>r1)&(f(x,y)<r2);
            ContStr(x,y)=Beta*(f(x,y)-r1)+s1;
        else f(x,y)>r2;
            ContStr(x,y)=Gamma*(f(x,y)-r2)+s2;
        end
    end
end

figure
ShowImage(uint8(ContStr),'Exp5 Image Contrast Stretching')
WriteImage(uint8(ContStr),'Exp5ImageContrastStretching.jpg') 
ContStrHist=CreateHistogram(uint8(ContStr));//Create Histogram
figure
plot2d3(ContStrHist)//Show Histogram
title('Contrast Stretched Histogram')
//Result
//Image Contrast Stretching   
//Set value r1 (0<r1<255):50
//Set value r2 (r1<r2<255: 100
//Set value s1 (0<s1<255):10
//Set value s2 (s1<s2<255: 100
